/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.PromptEditorKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SSV3DialogContent {
    private static final int MAX_PROMPT_WIDTH = 480;
    private AppInfo ainfo;
    private String mastheadKey;
    private String mainTextKey;
    private String locationKey;
    private String promptKey;
    private String multiPromptKey;
    private String multiTextKey;
    private String runTextKey;
    private String updateTextKey;
    private String cancelTextKey;
    private URL updateURL;
    private int userAnswer = -1;
    private JPanel contentPane;
    private DialogTemplate template;
    private JCheckBox multiClickCheckBox;
    private JButton runButton;
    private JButton updateButton;
    private JButton cancelButton;
    private AbstractAction cancelAction;
    private static Font ssvSmallFont;
    private static Font ssvSmallBoldFont;
    private static Font ssvFont;
    private static Font ssvBoldFont;
    private static Font ssvBigFont;
    private static Font ssvBigBoldFont;
    static int invokeCount;

    public SSV3DialogContent(AppInfo appInfo, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, URL uRL, DialogTemplate dialogTemplate) {
        SSV3DialogContent.setSSVFonts();
        this.template = dialogTemplate;
        this.ainfo = appInfo;
        this.mastheadKey = string2;
        this.mainTextKey = string3;
        this.locationKey = string4;
        this.promptKey = string5;
        this.multiPromptKey = string6;
        this.multiTextKey = string7;
        this.runTextKey = string8;
        this.updateTextKey = string9;
        this.cancelTextKey = string10;
        this.updateURL = uRL;
        this.initComponents();
    }

    public JPanel getContent() {
        return this.contentPane;
    }

    public int getAnswer() {
        if (this.userAnswer == -1) {
            this.userAnswer = 1;
        }
        return this.userAnswer;
    }

    private void initComponents() {
        this.contentPane = this.createContentPane();
        this.contentPane.add((Component)this.createMastHead(), "North");
        JComponent jComponent = this.createMainContent();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        this.contentPane.add((Component)jComponent, "Center");
        this.contentPane.add((Component)this.createOkCancelPanel(), "South");
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 24, 23, 15));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        return jPanel;
    }

    private JComponent createMastHead() {
        Component component = null;
        JLabel jLabel = new JLabel(this.getMessage(this.mastheadKey));
        jLabel.setFont(ssvBigBoldFont);
        jLabel.setOpaque(false);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        if (component != null) {
            box.add(component);
        }
        box.add(jLabel);
        return box;
    }

    private JComponent createMainContent() {
        JComponent jComponent = this.createWarningPanel();
        jComponent.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(jComponent);
        if (this.multiTextKey == null) {
            JEditorPane jEditorPane = this.createPrompt();
            box.add(this.createWarningMorePrompt(jEditorPane));
        }
        return box;
    }

    private JEditorPane createPrompt() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new PromptEditorKit(ssvSmallFont, ssvBoldFont, true));
        jEditorPane.setContentType("text/html");
        jEditorPane.setPreferredSize(this.getPromptPreferredSize(this.getMessage(this.promptKey)));
        jEditorPane.setText(this.html(this.getMessage(this.promptKey)));
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setOpaque(false);
        return jEditorPane;
    }

    private String html(String string) {
        String string2 = string.replaceAll("(" + this.getMessage(this.runTextKey) + ")|(" + this.getMessage(this.updateTextKey) + ")|(" + this.getMessage(this.cancelTextKey) + ")", "<b>$0</b>");
        return "<html><body>" + string2 + "</body></html>";
    }

    private Dimension getPromptPreferredSize(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setFont(jEditorPane.getFont().deriveFont(1));
        Font font = jEditorPane.getFont();
        jEditorPane.setSize(480, Short.MAX_VALUE);
        jEditorPane.setText(string);
        Dimension dimension = jEditorPane.getPreferredSize();
        int n = jEditorPane.getFontMetrics(font).getHeight();
        int n2 = n / 2;
        if (dimension.height > n) {
            n2 *= dimension.height / n;
        }
        dimension.height = dimension.height + n2 + 10;
        return dimension;
    }

    private JComponent createWarningPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createShieldIcon(), "West");
        Box box = Box.createVerticalBox();
        box.setOpaque(false);
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage(this.mainTextKey));
        jSmartTextArea.setFont(ssvBoldFont);
        jSmartTextArea.setLineWrap(true);
        jSmartTextArea.setWrapStyleWord(true);
        jSmartTextArea.setOpaque(false);
        jSmartTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        box.add(jSmartTextArea);
        box.add(this.createSourcesPanel());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    private JComponent createShieldIcon() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        jLabel.setIcon(ResourceManager.getIcon("warning48s.image"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 20));
        Box box = Box.createVerticalBox();
        box.add(jLabel);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private JComponent createSourcesPanel() {
        System.out.println(invokeCount++);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.putLabelsToPanel(jPanel, gridBagLayout, gridBagConstraints, this.createURLLabel(this.locationKey), this.createURLInfo(this.ainfo.getDisplayFrom(), this.ainfo.getFrom().toString()));
        if (this.ainfo.shouldDisplayMainJNLP()) {
            this.putLabelsToPanel(jPanel, gridBagLayout, gridBagConstraints, Box.createGlue(), this.createURLInfo(this.ainfo.getDisplayMainJNLP(), this.ainfo.getDisplayMainJNLPTooltip()));
        }
        if (this.ainfo.shouldDisplayDocumentBase()) {
            this.putLabelsToPanel(jPanel, gridBagLayout, gridBagConstraints, Box.createGlue(), this.createURLInfo(this.ainfo.getDisplayDocumentBase(), this.ainfo.getDocumentBase().toString()));
        }
        return jPanel;
    }

    private void putLabelsToPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, Component component2) {
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        jPanel.add(component2);
    }

    private JComponent createURLLabel(String string) {
        JLabel jLabel = new JLabel(this.getMessage(string));
        jLabel.setOpaque(false);
        jLabel.setFont(ssvSmallBoldFont);
        return jLabel;
    }

    private JComponent createURLInfo(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string2);
        jLabel.putClientProperty("html.disable", Boolean.TRUE);
        jLabel.setOpaque(false);
        return jLabel;
    }

    private JComponent createOkCancelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.runButton = this.makeButton(this.runTextKey);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3DialogContent.this.runAction();
            }
        });
        jPanel.add(this.runButton);
        if (this.updateTextKey != null) {
            this.updateButton = this.makeButton(this.updateTextKey);
            this.updateButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSV3DialogContent.this.updateAction();
                }
            });
            jPanel.add(this.updateButton);
        }
        this.cancelButton = this.makeButton(this.cancelTextKey);
        this.cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3DialogContent.this.cancelAction();
            }
        };
        this.cancelButton.addActionListener(this.cancelAction);
        this.template.getDialogInterface().setCancelAction(this.cancelAction);
        JButton[] jButtonArray = null;
        if (this.updateButton == null) {
            jButtonArray = new JButton[]{this.runButton, this.cancelButton};
            this.template.getDialogInterface().setInitialFocusComponent(this.cancelButton);
            this.template.getDialogInterface().setDefaultButton(this.cancelButton);
        } else {
            jButtonArray = new JButton[]{this.runButton, this.updateButton, this.cancelButton};
            this.template.getDialogInterface().setInitialFocusComponent(this.updateButton);
            this.template.getDialogInterface().setDefaultButton(this.updateButton);
        }
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel.add(this.cancelButton);
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        Box box = Box.createVerticalBox();
        this.createMultiSelection(box);
        box.add(jPanel);
        return box;
    }

    private void createMultiSelection(Box box) {
        if (this.multiPromptKey != null && this.multiTextKey != null) {
            this.runButton.setEnabled(false);
            JLabel jLabel = new JLabel(this.getMessage(this.multiPromptKey));
            jLabel.setOpaque(false);
            jLabel.setFont(ssvSmallBoldFont);
            Box box2 = this.createWarningMorePrompt(jLabel);
            Box box3 = Box.createHorizontalBox();
            box3.add(box2);
            box3.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            box.add(box3);
            this.multiClickCheckBox = new JCheckBox();
            this.setupCheckbox(box, this.multiTextKey, this.multiClickCheckBox);
            this.multiClickCheckBox.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SSV3DialogContent.this.runButton.setEnabled(SSV3DialogContent.this.multiClickCheckBox.isSelected());
                    if (SSV3DialogContent.this.multiClickCheckBox.isSelected()) {
                        SSV3DialogContent.this.template.getDialogInterface().setDefaultButton(SSV3DialogContent.this.runButton);
                        SSV3DialogContent.this.runButton.requestFocusInWindow();
                    } else if (SSV3DialogContent.this.updateButton != null) {
                        SSV3DialogContent.this.template.getDialogInterface().setDefaultButton(SSV3DialogContent.this.updateButton);
                        SSV3DialogContent.this.updateButton.requestFocusInWindow();
                    } else if (SSV3DialogContent.this.cancelButton != null) {
                        SSV3DialogContent.this.template.getDialogInterface().setDefaultButton(SSV3DialogContent.this.cancelButton);
                        SSV3DialogContent.this.cancelButton.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private JComponent getSecurityWarning() {
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("dialog.unsigned.security.risk.warning"));
        jSmartTextArea.setFont(ssvBoldFont);
        jSmartTextArea.setForeground(new Color(204, 0, 0));
        jSmartTextArea.setLineWrap(true);
        jSmartTextArea.setWrapStyleWord(true);
        jSmartTextArea.setOpaque(false);
        return jSmartTextArea;
    }

    private JComponent getMoreInfoButton() {
        String string = "dialog.template.more.info2";
        FancyButton fancyButton = new FancyButton(this.getMessage(string), ResourceManager.getMnemonic(string));
        fancyButton.setFont(ssvSmallFont);
        fancyButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof FancyButton) {
                    SSV3DialogContent.this.showMoreInfo();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        fancyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SSV3DialogContent.this.showMoreInfo();
            }
        });
        fancyButton.setAlignmentX(0.0f);
        fancyButton.setBorder(BorderFactory.createEmptyBorder());
        return fancyButton;
    }

    private void showMoreInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (SSV3DialogContent.isLocalApp(this.ainfo)) {
            arrayList.add(this.getMessage("sandbox.security.info.local.description"));
        } else {
            arrayList.add(this.getMessage("sandbox.security.info.description"));
        }
        if (this.updateTextKey != null) {
            arrayList.add(this.getMessage("deployment.dialog.ssv3.more.insecure"));
        }
        if (SSV3DialogContent.isLocalApp(this.ainfo)) {
            arrayList.add(this.getMessage("deployment.dialog.ssv3.more.local"));
        }
        if (this.multiTextKey != null) {
            arrayList.add(this.getMessage("deployment.dialog.ssv3.more.multi"));
        }
        arrayList.add(this.getMessage("deployment.dialog.ssv3.more.general"));
        MoreInfoDialog moreInfoDialog = new MoreInfoDialog(this.template.getDialogInterface().getDialog(), arrayList.toArray(new String[arrayList.size()]), null, 0, null, 0, 0, false, false, false);
        moreInfoDialog.setVisible(true);
    }

    private static boolean isLocalApp(AppInfo appInfo) {
        URL uRL = appInfo.getFrom();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    private Box createWarningMorePrompt(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(this.getMoreInfoButton());
        box.add(Box.createVerticalStrut(10));
        box.add(jComponent);
        return box;
    }

    private void setupCheckbox(Box box, String string, JCheckBox jCheckBox) {
        if (string != null) {
            jCheckBox.setOpaque(false);
            jCheckBox.setText(this.getMessage(string));
            jCheckBox.setMnemonic(this.getShortCut(string));
            Box box2 = Box.createHorizontalBox();
            box2.add(jCheckBox);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
        }
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        int n = this.getShortCut(string);
        if (n > 0) {
            jButton.setMnemonic(n);
        }
        jButton.setOpaque(false);
        return jButton;
    }

    private void runAction() {
        this.userAnswer = 0;
        this.closeDialog();
    }

    private void updateAction() {
        try {
            Platform.get().showDocument(this.updateURL.toString());
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    private void closeDialog() {
        this.template.setVisible(false);
    }

    private void cancelAction() {
        this.userAnswer = 1;
        this.closeDialog();
    }

    private String getMessage(String string) {
        if (string == null) {
            return null;
        }
        return ResourceManager.getMessage(string);
    }

    private int getShortCut(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    private static void setSSVFonts() {
        if (ssvFont == null) {
            int n;
            JLabel jLabel = new JLabel();
            int n2 = n = ResourceManager.getUIFont().getSize();
            int n3 = n + 1;
            int n4 = n + 4;
            ssvSmallFont = jLabel.getFont().deriveFont(0, n2);
            ssvSmallBoldFont = jLabel.getFont().deriveFont(1, n2);
            ssvFont = jLabel.getFont().deriveFont(0, n3);
            ssvBoldFont = jLabel.getFont().deriveFont(1, n3);
            ssvBigFont = jLabel.getFont().deriveFont(0, n4);
            ssvBigBoldFont = jLabel.getFont().deriveFont(1, n4);
        }
    }

    static {
        invokeCount = 0;
    }
}

