/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Headers
implements Iterable<Header> {
    private final Map<String, Header> headers;

    public Headers() {
        this.headers = new LinkedHashMap<String, Header>();
    }

    public Headers(Headers original, boolean immutable) {
        LinkedHashMap<String, Header> copy = new LinkedHashMap<String, Header>();
        copy.putAll(original.headers);
        this.headers = immutable ? Collections.unmodifiableMap(copy) : copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Headers that = (Headers)obj;
        return this.headers.equals(that.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public Set<String> names() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Header header : this.headers.values()) {
            result.add(header.name);
        }
        return result;
    }

    public Header get(String name) {
        return this.headers.get(name.trim().toLowerCase(Locale.ENGLISH));
    }

    public void put(String name, String value) {
        name = name.trim();
        Header header = new Header(name, value.trim(), new String[0]);
        this.headers.put(name.toLowerCase(Locale.ENGLISH), header);
    }

    public void put(Header header) {
        if (header != null) {
            this.headers.put(header.name().toLowerCase(Locale.ENGLISH), header);
        }
    }

    public void add(String name, String value) {
        Header header = this.headers.get((name = name.trim()).toLowerCase(Locale.ENGLISH));
        if (header == null) {
            header = new Header(name, value.trim(), new String[0]);
            this.headers.put(name.toLowerCase(Locale.ENGLISH), header);
        } else {
            header = new Header(header.name(), header.value() + "," + value.trim(), new String[0]);
            this.headers.put(name.toLowerCase(Locale.ENGLISH), header);
        }
    }

    public Header remove(String name) {
        name = name.trim();
        return this.headers.remove(name.toLowerCase(Locale.ENGLISH));
    }

    public void clear() {
        this.headers.clear();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public int size() {
        return this.headers.size();
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.values().iterator();
    }

    public String toString() {
        return this.headers.toString();
    }

    public static class Header {
        private final String name;
        private final String[] values;

        private Header(String name, String value, String ... values) {
            this.name = name;
            this.values = new String[values.length + 1];
            this.values[0] = value;
            if (values.length > 0) {
                System.arraycopy(values, 0, this.values, 1, values.length);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Header that = (Header)obj;
            return this.name.equalsIgnoreCase(that.name) && Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = this.name.toLowerCase(Locale.ENGLISH).hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.values[0];
        }

        public Integer valueAsInt() {
            String value = this.value();
            return value == null ? null : Integer.valueOf(value);
        }

        public String[] values() {
            return this.values;
        }

        public String valuesAsString() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.values[i]);
            }
            return result.toString();
        }

        public boolean hasMultipleValues() {
            return this.values.length > 1;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }
}

