/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private Vector inflaters = new Vector();

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        this.jzfile = ZipFile.open(string, n, file.lastModified(), usemmap);
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l = ZipFile.getEntry(this.jzfile, string, true);
            if (l != 0L) {
                ZipEntry zipEntry = new ZipEntry(string, l);
                ZipFile.freeEntry(this.jzfile, l);
                return zipEntry;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, String var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l = 0L;
        ZipFileInputStream zipFileInputStream = null;
        Object object = this;
        synchronized (object) {
            this.ensureOpen();
            l = ZipFile.getEntry(this.jzfile, string, false);
            if (l == 0L) {
                return null;
            }
            zipFileInputStream = new ZipFileInputStream(l);
        }
        object = zipFileInputStream;
        switch (ZipFile.getMethod(l)) {
            case 0: {
                return object;
            }
            case 8: {
                long l2 = ZipFile.getSize(l) + 2L;
                if (l2 > 65536L) {
                    l2 = 8192L;
                }
                if (l2 <= 0L) {
                    l2 = 4096L;
                }
                return new InflaterInputStream((InputStream)object, this.getInflater(), (int)l2, (ZipFileInputStream)object){
                    private boolean isClosed;
                    private boolean eof;
                    final /* synthetic */ ZipFileInputStream val$zfin;
                    {
                        this.val$zfin = zipFileInputStream;
                        super(inputStream, inflater, n);
                        this.isClosed = false;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    public int available() throws IOException {
                        if (this.isClosed) {
                            return 0;
                        }
                        long l = this.val$zfin.size() - this.inf.getBytesWritten();
                        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    private static native int getMethod(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n - 1);
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            inflater.reset();
            this.inflaters.add(inflater);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration<ZipEntry>(){
            private int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    return this.i < ZipFile.this.total;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    long l = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (l == 0L) {
                        String string = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                        throw new ZipError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                    }
                    ZipEntry zipEntry = new ZipEntry(l);
                    ZipFile.freeEntry(ZipFile.this.jzfile, l);
                    return zipEntry;
                }
            }
        };
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.closeRequested = true;
            if (this.jzfile != 0L) {
                long l = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(l);
                Vector vector = this.inflaters;
                synchronized (vector) {
                    int n = this.inflaters.size();
                    for (int i = 0; i < n; ++i) {
                        Inflater inflater = (Inflater)this.inflaters.get(i);
                        inflater.end();
                    }
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getCSize(long var0);

    private static native long getSize(long var0);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.zip.disableMemoryMapping"));
        usemmap = string == null || string.length() != 0 && !string.equalsIgnoreCase("true");
    }

    private class ZipFileInputStream
    extends InputStream {
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l) {
            this.rem = ZipFile.getCSize(l);
            this.size = ZipFile.getSize(l);
            this.jzentry = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.rem == 0L) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.rem) {
                n2 = (int)this.rem;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                n2 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, byArray, n, n2);
            }
            if (n2 > 0) {
                this.pos += (long)n2;
                this.rem -= (long)n2;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long l) {
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            if (this.rem == 0L) {
                this.close();
            }
            return l;
        }

        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.rem = 0L;
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
        }
    }
}

