/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;
    private static final boolean enableSNIExtension = Debug.getBooleanProperty("jsse.enableSNIExtension", true);
    private static final boolean allowUnsafeServerCertChange = Debug.getBooleanProperty("jdk.tls.allowUnsafeServerCertChange", false);
    private List<SNIServerName> requestedServerNames = Collections.emptyList();
    private boolean serverNamesAccepted = false;
    private X509Certificate[] reservedServerCerts = null;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, true, true, protocolVersion, bl, bl2, byArray, byArray2);
    }

    ClientHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, true, true, protocolVersion, bl, bl2, byArray, byArray2);
    }

    @Override
    void processMessage(byte by, int n) throws IOException {
        if (this.state >= by && by != 0) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        block4 : switch (by) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, n));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA_EXPORT: {
                        if (this.serverKey == null) {
                            throw new SSLProtocolException("Server did not send certificate message");
                        }
                        if (!(this.serverKey instanceof RSAPublicKey)) {
                            throw new SSLProtocolException("Protocol violation: the certificate type must be appropriate for the selected cipher suite's key exchange algorithm");
                        }
                        if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                            throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange) + " when the public key in the server certificate" + " is less than or equal to 512 bits in length");
                        }
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_DH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, n, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block4;
                    }
                    case K_RSA: 
                    case K_DH_RSA: 
                    case K_DH_DSS: 
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input, this.protocolVersion);
                if (debug != null && Debug.isOn("handshake")) {
                    this.certRequest.print(System.out);
                }
                if (this.protocolVersion.v < ProtocolVersion.TLS12.v) break;
                Collection<SignatureAndHashAlgorithm> collection = this.certRequest.getSignAlgorithms();
                if (collection == null || collection.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                Collection<SignatureAndHashAlgorithm> collection2 = SignatureAndHashAlgorithm.getSupportedAlgorithms(collection);
                if (collection2.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs(collection2);
                this.session.setPeerSupportedSignatureAlgorithms(collection2);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                if (!this.receivedChangeCipherSpec()) {
                    this.fatalSE((byte)40, "Received Finished message before ChangeCipherSpec");
                }
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest helloRequest) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            helloRequest.print(System.out);
        }
        if (this.state < 1) {
            if (!this.secureRenegotiation && !allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                } else {
                    this.fatalSE((byte)40, "Renegotiation is not allowed");
                }
            } else {
                if (!this.secureRenegotiation && debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: continue with insecure renegotiation");
                }
                this.kickstart();
            }
        }
    }

    private void serverHello(HandshakeMessage.ServerHello serverHello) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ProtocolVersion protocolVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
        }
        if (!this.isNegotiable(protocolVersion = serverHello.protocolVersion)) {
            throw new SSLHandshakeException("Server chose " + protocolVersion + ", but that protocol version is not enabled or not supported " + "by the client.");
        }
        this.handshakeHash.protocolDetermined(protocolVersion);
        this.setVersion(protocolVersion);
        RenegotiationInfoExtension renegotiationInfoExtension = (RenegotiationInfoExtension)serverHello.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (renegotiationInfoExtension != null) {
            if (this.isInitialHandshake) {
                if (!renegotiationInfoExtension.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "Unexpected renegotiation indication extension");
                }
                object3 = new byte[this.clientVerifyData.length + this.serverVerifyData.length];
                System.arraycopy(this.clientVerifyData, 0, object3, 0, this.clientVerifyData.length);
                System.arraycopy(this.serverVerifyData, 0, object3, this.clientVerifyData.length, this.serverVerifyData.length);
                if (!MessageDigest.isEqual((byte[])object3, renegotiationInfoExtension.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (this.isInitialHandshake) {
            if (!allowLegacyHelloMessages) {
                this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            this.secureRenegotiation = false;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Warning: No renegotiation indication extension in ServerHello");
            }
        } else if (this.secureRenegotiation) {
            this.fatalSE((byte)40, "No renegotiation indication extension");
        }
        this.svr_random = serverHello.svr_random;
        if (!this.isNegotiable(serverHello.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected improper ciphersuite " + serverHello.cipherSuite);
        }
        this.setCipherSuite(serverHello.cipherSuite);
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.getPRFHashAlg());
        }
        if (serverHello.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + serverHello.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(serverHello.sessionId)) {
                object3 = this.session.getSuite();
                if (this.cipherSuite != object3) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                object2 = this.session.getProtocolVersion();
                if (this.protocolVersion != object2) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (((CipherSuite)object3).keyExchange == CipherSuite.KeyExchange.K_KRB5 || ((CipherSuite)object3).keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    block37: {
                        object = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Helper.getClientSubject(ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block37;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<Principal> set = subject.getPrincipals(Principal.class);
                        if (!set.contains(object)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
            } else {
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation is disabled");
                }
            }
        }
        if (this.resumingSession && this.session != null) {
            this.setHandshakeSessionSE(this.session);
            if (this.isInitialHandshake) {
                this.session.setAsSessionResumption(true);
            }
            return;
        }
        object3 = serverHello.extensions.list().iterator();
        while (object3.hasNext()) {
            object2 = (HelloExtension)object3.next();
            object = ((HelloExtension)object2).type;
            if (object == ExtensionType.EXT_SERVER_NAME) {
                this.serverNamesAccepted = true;
                continue;
            }
            if (object == ExtensionType.EXT_ELLIPTIC_CURVES || object == ExtensionType.EXT_EC_POINT_FORMATS || object == ExtensionType.EXT_SERVER_NAME || object == ExtensionType.EXT_RENEGOTIATION_INFO) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + object);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.getLocalSupportedSignAlgs(), serverHello.sessionId, this.getHostSE(), this.getPortSE());
        this.session.setRequestedServerNames(this.requestedServerNames);
        this.setHandshakeSessionSE(this.session);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.cipherSuite);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange rSA_ServerKeyExchange) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn("handshake")) {
            rSA_ServerKeyExchange.print(System.out);
        }
        if (!rSA_ServerKeyExchange.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = rSA_ServerKeyExchange.getPublicKey();
        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), this.ephemeralServerKey)) {
            throw new SSLHandshakeException("RSA ServerKeyExchange does not comply to algorithm constraints");
        }
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.print(System.out);
        }
        this.dh = new DHCrypt(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = dH_ServerKeyExchange.getServerPublicKey();
        this.dh.checkConstraints(this.algorithmConstraints, this.serverDH);
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange eCDH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            eCDH_ServerKeyExchange.print(System.out);
        }
        ECPublicKey eCPublicKey = eCDH_ServerKeyExchange.getPublicKey();
        this.ecdh = new ECDHCrypt(eCPublicKey.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = eCPublicKey;
        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), this.ephemeralServerKey)) {
            throw new SSLHandshakeException("ECDH ServerKeyExchange does not comply to algorithm constraints");
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void serverHelloDone(HandshakeMessage.ServerHelloDone var1_1) throws IOException {
        if (ClientHandshaker.debug != null && Debug.isOn("handshake")) {
            var1_1.print(System.out);
        }
        this.input.digestNow();
        var2_2 = null;
        if (this.certRequest != null) {
            var3_3 = this.sslContext.getX509KeyManager();
            var4_4 /* !! */  = new ArrayList<E>(4);
            for (var5_5 = 0; var5_5 < this.certRequest.types.length; ++var5_5) {
                switch (this.certRequest.types[var5_5]) {
                    case 1: {
                        var6_7 = "RSA";
                        break;
                    }
                    case 2: {
                        var6_7 = "DSA";
                        break;
                    }
                    case 64: {
                        var6_7 = JsseJce.isEcAvailable() != false ? "EC" : null;
                        break;
                    }
                    default: {
                        var6_7 = null;
                    }
                }
                if (var6_7 == null || var4_4 /* !! */ .contains(var6_7)) continue;
                var4_4 /* !! */ .add(var6_7);
            }
            var5_6 = null;
            var6_8 = var4_4 /* !! */ .size();
            if (var6_8 != 0) {
                var7_13 = var4_4 /* !! */ .toArray(new String[var6_8]);
                var5_6 = this.conn != null ? var3_3.chooseClientAlias((String[])var7_13, this.certRequest.getAuthorities(), this.conn) : var3_3.chooseEngineClientAlias((String[])var7_13, this.certRequest.getAuthorities(), this.engine);
            }
            var7_13 = null;
            if (var5_6 != null && (var8_14 /* !! */  = var3_3.getCertificateChain((String)var5_6)) != null && var8_14 /* !! */ .length != 0) {
                var9_16 = var8_14 /* !! */ [0].getPublicKey();
                if (var9_16 instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported(var11_18 = SupportedEllipticCurvesExtension.getCurveIndex(var10_17 = ((ECPublicKey)var9_16).getParams()))) {
                    var9_16 = null;
                }
                if (var9_16 != null) {
                    var7_13 = new HandshakeMessage.CertificateMsg(var8_14 /* !! */ );
                    var2_2 = var3_3.getPrivateKey((String)var5_6);
                    this.session.setLocalPrivateKey((PrivateKey)var2_2);
                    this.session.setLocalCertificates(var8_14 /* !! */ );
                }
            }
            if (var7_13 == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    var7_13 = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
                if (ClientHandshaker.debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: no suitable certificate found - continuing without client authentication");
                }
            }
            if (var7_13 != null) {
                if (ClientHandshaker.debug != null && Debug.isOn("handshake")) {
                    var7_13.print(System.out);
                }
                var7_13.write(this.output);
            }
        }
        switch (2.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[this.keyExchange.ordinal()]) {
            case 1: 
            case 8: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof RSAPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an RSA key");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_RSA) {
                    var4_4 /* !! */  = this.serverKey;
                } else if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                    var4_4 /* !! */  = this.serverKey;
                } else {
                    if (this.ephemeralServerKey == null) {
                        throw new SSLProtocolException("Server did not send a RSA_EXPORT Server Key Exchange message");
                    }
                    var4_4 /* !! */  = this.ephemeralServerKey;
                }
                var3_3 = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), (PublicKey)var4_4 /* !! */ );
                break;
            }
            case 9: 
            case 10: {
                var3_3 = new DHClientKeyExchange();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                var3_3 = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                var3_3 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case 11: 
            case 12: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                var5_6 = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt((ECParameterSpec)var5_6, this.sslContext.getSecureRandom());
                var3_3 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case 13: 
            case 14: {
                var6_9 = null;
                for (X509Certificate[] var8_14 : this.requestedServerNames) {
                    if (!(var8_14 /* !! */  instanceof SNIHostName)) continue;
                    var6_9 = ((SNIHostName)var8_14 /* !! */ ).getAsciiName();
                    break;
                }
                var7_13 = null;
                if (var6_9 == null) ** GOTO lbl106
                try {
                    var7_13 = new KerberosClientKeyExchange(var6_9, this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                }
                catch (IOException var8_15) {
                    if (this.serverNamesAccepted) {
                        throw var8_15;
                    }
                    if (ClientHandshaker.debug == null || !Debug.isOn("handshake")) ** GOTO lbl106
                    System.out.println("Warning, cannot use Server Name Indication: " + var8_15.getMessage());
                }
lbl106:
                // 4 sources

                if (var7_13 == null) {
                    var8_14 /* !! */  = this.getHostSE();
                    if (var8_14 /* !! */  == null) {
                        throw new IOException("Hostname is required to use Kerberos cipher suites");
                    }
                    var7_13 = new KerberosClientKeyExchange((String)var8_14 /* !! */ , this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                }
                this.session.setPeerPrincipal(var7_13.getPeerPrincipal());
                this.session.setLocalPrincipal(var7_13.getLocalPrincipal());
                var3_3 = var7_13;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)this.keyExchange);
            }
        }
        if (ClientHandshaker.debug != null && Debug.isOn("handshake")) {
            var3_3.print(System.out);
        }
        var3_3.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (2.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[this.keyExchange.ordinal()]) {
            case 1: 
            case 8: {
                var4_4 /* !! */  = ((RSAClientKeyExchange)var3_3).preMaster;
                break;
            }
            case 13: 
            case 14: {
                var5_6 = ((KerberosClientKeyExchange)var3_3).getUnencryptedPreMasterSecret();
                var4_4 /* !! */  = new SecretKeySpec((byte[])var5_6, "TlsPremasterSecret");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                var4_4 /* !! */  = this.dh.getAgreedSecret(this.serverDH, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                var4_4 /* !! */  = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case 11: 
            case 12: {
                var4_4 /* !! */  = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)this.keyExchange);
            }
        }
        this.calculateKeys((SecretKey)var4_4 /* !! */ , null);
        if (var2_2 != null) {
            try {
                var6_11 = null;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    var6_11 = SignatureAndHashAlgorithm.getPreferableAlgorithm(this.peerSupportedSignAlgs, var2_2.getAlgorithm(), (PrivateKey)var2_2);
                    if (var6_11 == null) {
                        throw new SSLHandshakeException("No supported signature algorithm");
                    }
                    var7_13 = SignatureAndHashAlgorithm.getHashAlgorithmName(var6_11);
                    if (var7_13 == null || var7_13.length() == 0) {
                        throw new SSLHandshakeException("No supported hash algorithm");
                    }
                }
                var5_6 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, (PrivateKey)var2_2, this.session.getMasterSecret(), this.sslContext.getSecureRandom(), var6_11);
            }
            catch (GeneralSecurityException var6_12) {
                this.fatalSE((byte)40, "Error signing certificate verify", var6_12);
                var5_6 = null;
            }
            if (ClientHandshaker.debug != null && Debug.isOn("handshake")) {
                var5_6.print(System.out);
            }
            var5_6.write(this.output);
            this.output.doHashes();
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (!(bl = finished.verify(this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.serverVerifyData = finished.getVerifyData();
        }
        if (!this.isInitialHandshake) {
            this.session.setAsSessionResumption(false);
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(finished, bl);
        if (this.secureRenegotiation) {
            this.clientVerifyData = finished.getVerifyData();
        }
        this.state = 19;
    }

    @Override
    HandshakeMessage getKickstartMessage() throws SSLException {
        Object object;
        Object object2;
        SessionId sessionId = SSLSessionImpl.nullSession.getSessionId();
        CipherSuiteList cipherSuiteList = this.getActiveCipherSuites();
        this.maxProtocolVersion = this.protocolVersion;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null) {
            if (!allowUnsafeServerCertChange && this.session.isSessionResumption()) {
                try {
                    this.reservedServerCerts = (X509Certificate[])this.session.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            if (!this.session.isRejoinable()) {
                this.session = null;
            }
        }
        if (this.session != null) {
            object2 = this.session.getSuite();
            object = this.session.getProtocolVersion();
            if (!this.isNegotiable((CipherSuite)object2)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, unavailable cipher");
                }
                this.session = null;
            }
            if (this.session != null && !this.isNegotiable((ProtocolVersion)object)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                sessionId = this.session.getSessionId();
                this.maxProtocolVersion = object;
                this.setVersion((ProtocolVersion)object);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLHandshakeException("Can't reuse existing SSL client session");
                }
                ArrayList<CipherSuite> collection2 = new ArrayList<CipherSuite>(2);
                collection2.add((CipherSuite)object2);
                if (!this.secureRenegotiation && cipherSuiteList.contains(CipherSuite.C_SCSV)) {
                    collection2.add(CipherSuite.C_SCSV);
                }
                cipherSuiteList = new CipherSuiteList(collection2);
            }
        }
        if (this.session == null && !this.enableNewSession) {
            throw new SSLHandshakeException("No existing session to resume");
        }
        if (this.secureRenegotiation && cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            object2 = new ArrayList(cipherSuiteList.size() - 1);
            for (CipherSuite cipherSuite : cipherSuiteList.collection()) {
                if (cipherSuite == CipherSuite.C_SCSV) continue;
                object2.add(cipherSuite);
            }
            cipherSuiteList = new CipherSuiteList((Collection<CipherSuite>)object2);
        }
        boolean bl = false;
        for (CipherSuite cipherSuite : cipherSuiteList.collection()) {
            if (!this.isNegotiable(cipherSuite)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SSLHandshakeException("No negotiable cipher suite");
        }
        object = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.maxProtocolVersion, sessionId, cipherSuiteList);
        if (this.maxProtocolVersion.v >= ProtocolVersion.TLS12.v) {
            Collection<SignatureAndHashAlgorithm> collection = this.getLocalSupportedSignAlgs();
            if (collection.isEmpty()) {
                throw new SSLHandshakeException("No supported signature algorithm");
            }
            ((HandshakeMessage.ClientHello)object).addSignatureAlgorithmsExtension(collection);
        }
        if (enableSNIExtension) {
            this.requestedServerNames = this.session != null ? this.session.getRequestedServerNames() : this.serverNames;
            if (!this.requestedServerNames.isEmpty()) {
                ((HandshakeMessage.ClientHello)object).addSNIExtension(this.requestedServerNames);
            }
        }
        this.clnt_random = ((HandshakeMessage.ClientHello)object).clnt_random;
        if (this.secureRenegotiation || !cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            ((HandshakeMessage.ClientHello)object).addRenegotiationInfoExtension(this.clientVerifyData);
        }
        return object;
    }

    @Override
    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        block8: {
            Object object;
            if (debug != null && Debug.isOn("handshake")) {
                certificateMsg.print(System.out);
            }
            if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if (!(this.reservedServerCerts == null || (object = this.getEndpointIdentificationAlgorithmSE()) != null && ((String)object).length() != 0 || ClientHandshaker.isIdentityEquivalent(x509CertificateArray[0], this.reservedServerCerts[0]))) {
                this.fatalSE((byte)42, "server certificate change is restricted during renegotiation");
            }
            object = this.sslContext.getX509TrustManager();
            try {
                String string = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
                if (object instanceof X509ExtendedTrustManager) {
                    if (this.conn != null) {
                        ((X509ExtendedTrustManager)object).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this.conn);
                    } else {
                        ((X509ExtendedTrustManager)object).checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this.engine);
                    }
                    break block8;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException certificateException) {
                this.fatalSE((byte)46, certificateException);
            }
        }
        this.session.setPeerCertificates(x509CertificateArray);
    }

    private static boolean isIdentityEquivalent(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<List<?>> collection;
        Collection<List<?>> collection2;
        block9: {
            block8: {
                if (x509Certificate.equals(x509Certificate2)) {
                    return true;
                }
                collection2 = null;
                try {
                    collection2 = x509Certificate.getSubjectAlternativeNames();
                }
                catch (CertificateParsingException certificateParsingException) {
                    if (debug == null || !Debug.isOn("handshake")) break block8;
                    System.out.println("Attempt to obtain subjectAltNames extension failed!");
                }
            }
            collection = null;
            try {
                collection = x509Certificate2.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug == null || !Debug.isOn("handshake")) break block9;
                System.out.println("Attempt to obtain subjectAltNames extension failed!");
            }
        }
        if (collection2 != null && collection != null) {
            object4 = ClientHandshaker.getSubjectAltNames(collection2, 7);
            object3 = ClientHandshaker.getSubjectAltNames(collection, 7);
            if (object4 != null && object3 != null && ClientHandshaker.isEquivalent((Collection<String>)object4, (Collection<String>)object3)) {
                return true;
            }
            object2 = ClientHandshaker.getSubjectAltNames(collection2, 2);
            object = ClientHandshaker.getSubjectAltNames(collection, 2);
            if (object2 != null && object != null && ClientHandshaker.isEquivalent((Collection<String>)object2, (Collection<String>)object)) {
                return true;
            }
        }
        object4 = x509Certificate.getSubjectX500Principal();
        object3 = x509Certificate2.getSubjectX500Principal();
        object2 = x509Certificate.getIssuerX500Principal();
        object = x509Certificate2.getIssuerX500Principal();
        return !((X500Principal)object4).getName().isEmpty() && !((X500Principal)object3).getName().isEmpty() && ((X500Principal)object4).equals(object3) && ((X500Principal)object2).equals(object);
    }

    private static Collection<String> getSubjectAltNames(Collection<List<?>> collection, int n) {
        HashSet<String> hashSet = null;
        for (List<?> list : collection) {
            String string;
            int n2 = (Integer)list.get(0);
            if (n2 != n || (string = (String)list.get(1)) == null || string.isEmpty()) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>(collection.size());
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    private static boolean isEquivalent(Collection<String> collection, Collection<String> collection2) {
        for (String string : collection) {
            for (String string2 : collection2) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

