/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.session.infinispan.InfinispanSessionIdManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.infinispan.commons.api.BasicCache;

public class InfinispanSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private BasicCache<String, Object> _cache;
    private ConcurrentHashMap<String, Session> _sessions;
    private long _staleIntervalSec = 0L;
    protected Scheduler.Task _task;
    protected Scheduler _scheduler;
    protected Scavenger _scavenger;
    protected long _scavengeIntervalMs = 600000L;
    protected boolean _ownScheduler;

    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        if (this._cache == null) {
            throw new IllegalStateException("No session cache defined");
        }
        this._sessions = new ConcurrentHashMap();
        this._scheduler = (Scheduler)this.getSessionHandler().getServer().getBean(Scheduler.class);
        if (this._scheduler == null) {
            this._scheduler = new ScheduledExecutorScheduler();
            this._ownScheduler = true;
            this._scheduler.start();
        } else if (!this._scheduler.isStarted()) {
            throw new IllegalStateException("Shared scheduler not started");
        }
        this.setScavengeInterval(this.getScavengeInterval());
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this._task != null) {
            this._task.cancel();
        }
        this._task = null;
        if (this._ownScheduler && this._scheduler != null) {
            this._scheduler.stop();
        }
        this._scheduler = null;
        this._sessions.clear();
        this._sessions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge() {
        HashSet<String> candidateIds = new HashSet<String>();
        long now = System.currentTimeMillis();
        LOG.info("SessionManager for context {} scavenging at {} ", new Object[]{InfinispanSessionManager.getContextPath(this.getContext()), now});
        ConcurrentHashMap<String, Session> concurrentHashMap = this._sessions;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, Session> entry : this._sessions.entrySet()) {
                long expiry = entry.getValue().getExpiry();
                if (expiry <= 0L || expiry >= now) continue;
                candidateIds.add(entry.getKey());
            }
        }
        for (String candidateId : candidateIds) {
            Session candidateSession;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} expired ", new Object[]{candidateId});
            }
            if ((candidateSession = this._sessions.get(candidateId)) == null) continue;
            Session cachedSession = this.load(this.makeKey(candidateId, this._context));
            if (cachedSession == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Locally expired session({}) does not exist in cluster ", new Object[]{candidateId});
                }
                candidateSession.timeout();
                continue;
            }
            if (this.getSessionIdManager().getWorkerName().equals(cachedSession.getLastNode())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expiring session({}) local to session manager", new Object[]{candidateId});
                }
                candidateSession.timeout();
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session({}) not local to this session manager, removing from local memory", new Object[]{candidateId});
            }
            candidateSession.willPassivate();
            this._sessions.remove(candidateSession.getClusterId());
        }
    }

    public long getScavengeInterval() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeInterval(long sec) {
        long period;
        if (sec <= 0L) {
            sec = 60L;
        }
        long old_period = this._scavengeIntervalMs;
        this._scavengeIntervalMs = period = sec * 1000L;
        long tenPercent = this._scavengeIntervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._scavengeIntervalMs += tenPercent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging every " + this._scavengeIntervalMs + " ms", new Object[0]);
        }
        InfinispanSessionManager infinispanSessionManager = this;
        synchronized (infinispanSessionManager) {
            if (this._scheduler != null && (period != old_period || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                }
                if (this._scavenger == null) {
                    this._scavenger = new Scavenger();
                }
                this._task = this._scheduler.schedule((Runnable)this._scavenger, this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public BasicCache<String, Object> getCache() {
        return this._cache;
    }

    public void setCache(BasicCache<String, Object> cache) {
        this._cache = cache;
    }

    public long getStaleIntervalSec() {
        return this._staleIntervalSec;
    }

    public void setStaleIntervalSec(long staleIntervalSec) {
        this._staleIntervalSec = staleIntervalSec;
    }

    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding session({}) to session manager for context {} on worker {}", new Object[]{session.getClusterId(), InfinispanSessionManager.getContextPath(this.getContext()), this.getSessionIdManager().getWorkerName() + " with lastnode=" + ((Session)session).getLastNode()});
        }
        this._sessions.put(session.getClusterId(), (Session)session);
        try {
            session.willPassivate();
            this.save((Session)session);
            session.didActivate();
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), (Throwable)e);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        Session session = null;
        Session memSession = this._sessions.get(idInCluster);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSession({}) {} in session map", new Object[]{idInCluster, memSession == null ? "not" : ""});
        }
        long now = System.currentTimeMillis();
        try {
            if (memSession == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getSession({}): loading session data from cluster", new Object[]{idInCluster});
                }
                if ((session = this.load(this.makeKey(idInCluster, this._context))) != null) {
                    if (session.getExpiry() > 0L && session.getExpiry() <= now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession ({}): Session expired", new Object[]{idInCluster});
                        }
                        ((InfinispanSessionIdManager)this.getSessionIdManager()).removeSession((HttpSession)session);
                        return null;
                    }
                    session.setLastNode(this.getSessionIdManager().getWorkerName());
                    Session existingSession = this._sessions.putIfAbsent(idInCluster, session);
                    if (existingSession != null) {
                        session = existingSession;
                        LOG.debug("getSession({}): using session loaded by another request thread ", new Object[]{idInCluster});
                    } else {
                        session.didActivate();
                        LOG.debug("getSession({}): loaded session from cluster", new Object[]{idInCluster});
                    }
                    return session;
                }
                LOG.debug("getSession({}): No session in cluster matching", new Object[]{idInCluster});
                return null;
            }
            LOG.debug("getSession({}): returning session from local memory ", new Object[]{memSession.getClusterId()});
            return memSession;
        }
        catch (Exception e) {
            LOG.warn("Unable to load session=" + idInCluster, (Throwable)e);
            return null;
        }
    }

    protected void shutdownSessions() throws Exception {
        HashSet keys = new HashSet(this._sessions.keySet());
        for (String key : keys) {
            Session session = this._sessions.remove(key);
            try {
                if (!session.isDirty()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Saving dirty session {} before exiting ", new Object[]{session.getId()});
                }
                this.save(session);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected boolean removeSession(String idInCluster) {
        Session session = this._sessions.remove(idInCluster);
        try {
            if (session != null) {
                this.delete(session);
            }
        }
        catch (Exception e) {
            LOG.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
        }
        return session != null;
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        Session session = null;
        try {
            session = this._sessions.remove(oldClusterId);
            if (session != null) {
                this.delete(session);
                session.swapId(newClusterId, newNodeId);
                this._sessions.put(newClusterId, session);
                this.save(session);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        super.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
    }

    protected Session load(String key) {
        SerializableSessionData storableSession;
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading session {} from cluster", new Object[]{key});
        }
        if ((storableSession = (SerializableSessionData)this._cache.get((Object)key)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No session {} in cluster ", new Object[]{key});
            }
            return null;
        }
        Session session = new Session(storableSession);
        session.setLastSyncTime(System.currentTimeMillis());
        return session;
    }

    protected void save(Session session) throws Exception {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing session {} to cluster", new Object[]{session.getId()});
        }
        SerializableSessionData storableSession = new SerializableSessionData(session);
        InfinispanSessionIdManager sessionIdManager = (InfinispanSessionIdManager)this.getSessionIdManager();
        if (storableSession.maxInactive > 0L) {
            this._cache.put((Object)this.makeKey(session, this._context), (Object)storableSession, -1L, TimeUnit.SECONDS, storableSession.maxInactive * (long)sessionIdManager.getIdleExpiryMultiple(), TimeUnit.SECONDS);
        } else {
            this._cache.put((Object)this.makeKey(session, this._context), (Object)storableSession);
        }
        sessionIdManager.touch(session.getClusterId());
        session.setLastSyncTime(System.currentTimeMillis());
    }

    protected void delete(Session session) {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing session {} from cluster", new Object[]{session.getId()});
        }
        this._cache.remove((Object)this.makeKey(session, this._context));
    }

    public void invalidateSession(String idInCluster) {
        Session session = this._sessions.get(idInCluster);
        if (session != null) {
            session.invalidate();
        }
    }

    private String makeKey(Session session, ContextHandler.Context context) {
        return this.makeKey(session.getId(), context);
    }

    private String makeKey(String id, ContextHandler.Context context) {
        String key = InfinispanSessionManager.getContextPath(context);
        key = key + "_" + InfinispanSessionManager.getVirtualHost(context);
        key = key + "_" + id;
        return key;
    }

    private static String getContextPath(ContextHandler.Context context) {
        return InfinispanSessionManager.canonicalize(context.getContextPath());
    }

    private static String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private static String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    public class Session
    extends MemSession {
        private ReentrantLock _lock;
        private String _contextPath;
        private long _expiryTime;
        private long _lastSyncTime;
        private String _lastNode;
        protected boolean _dirty;
        private String _vhost;
        private AtomicInteger _activeThreads;

        protected Session(HttpServletRequest request) {
            super((AbstractSessionManager)InfinispanSessionManager.this, request);
            this._lock = new ReentrantLock();
            this._dirty = false;
            this._activeThreads = new AtomicInteger(0);
            long maxInterval = this.getMaxInactiveInterval();
            this._expiryTime = maxInterval <= 0L ? 0L : System.currentTimeMillis() + maxInterval * 1000L;
            this._lastNode = InfinispanSessionManager.this.getSessionIdManager().getWorkerName();
            this.setVHost(InfinispanSessionManager.getVirtualHost(InfinispanSessionManager.this._context));
            this.setContextPath(InfinispanSessionManager.getContextPath(InfinispanSessionManager.this._context));
            this._activeThreads.incrementAndGet();
        }

        protected Session(SerializableSessionData sd) {
            super((AbstractSessionManager)InfinispanSessionManager.this, sd.createTime, sd.accessed, sd.clusterId);
            this._lock = new ReentrantLock();
            this._dirty = false;
            this._activeThreads = new AtomicInteger(0);
            this._expiryTime = sd.maxInactive <= 0L ? 0L : System.currentTimeMillis() + sd.maxInactive * 1000L;
            this.setLastNode(sd.lastNode);
            this.setContextPath(sd.contextPath);
            this.setVHost(sd.vhost);
            this.addAttributes(sd.attributes);
        }

        protected Session(String sessionId, long created, long accessed, long maxInterval) {
            super((AbstractSessionManager)InfinispanSessionManager.this, created, accessed, sessionId);
            this._lock = new ReentrantLock();
            this._dirty = false;
            this._activeThreads = new AtomicInteger(0);
            this._expiryTime = maxInterval <= 0L ? 0L : System.currentTimeMillis() + maxInterval * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean access(long time) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Access session({}) for context {} on worker {}", new Object[]{this.getId(), this.getContextPath(), InfinispanSessionManager.this.getSessionIdManager().getWorkerName()});
            }
            try {
                long now = System.currentTimeMillis();
                this._lock.lock();
                if (this._activeThreads.incrementAndGet() == 1 && InfinispanSessionManager.this.getStaleIntervalSec() > 0L && now - this.getLastSyncTime() >= InfinispanSessionManager.this.getStaleIntervalSec() * 1000L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Acess session({}) for context {} on worker {} stale session. Reloading.", new Object[]{this.getId(), this.getContextPath(), InfinispanSessionManager.this.getSessionIdManager().getWorkerName()});
                    }
                    this.refresh();
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this._lock.unlock();
            }
            if (super.access(time)) {
                int maxInterval = this.getMaxInactiveInterval();
                this._expiryTime = maxInterval <= 0 ? 0L : time + (long)maxInterval * 1000L;
                return true;
            }
            return false;
        }

        protected void complete() {
            block9: {
                super.complete();
                this._lock.lock();
                try {
                    if (this._activeThreads.decrementAndGet() != 0) break block9;
                    try {
                        if (this.isValid() && (this._dirty || this.getLastSyncTime() == 0L || this.isStale(System.currentTimeMillis()))) {
                            this.willPassivate();
                            InfinispanSessionManager.this.save(this);
                            this.didActivate();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Problem saving session({})", new Object[]{this.getId(), e});
                    }
                    finally {
                        this._dirty = false;
                    }
                }
                finally {
                    this._lock.unlock();
                }
            }
        }

        protected boolean isStale(long atTime) {
            return InfinispanSessionManager.this.getStaleIntervalSec() > 0L && atTime - this.getLastSyncTime() >= InfinispanSessionManager.this.getStaleIntervalSec() * 1000L;
        }

        protected boolean isDirty() {
            return this._dirty;
        }

        protected void timeout() {
            super.timeout();
        }

        private void refresh() {
            Session fresh = InfinispanSessionManager.this.load(InfinispanSessionManager.this.makeKey(this.getClusterId(), InfinispanSessionManager.this._context));
            if (fresh == null) {
                this.invalidate();
                return;
            }
            if (fresh.getLastNode().equals(this.getLastNode())) {
                return;
            }
            this.setLastNode(InfinispanSessionManager.this.getSessionIdManager().getWorkerName());
            this.willPassivate();
            if (fresh.getAttributes() == 0) {
                this.clearAttributes();
            } else {
                for (String key : fresh.getAttributeMap().keySet()) {
                    Object freshvalue = fresh.getAttribute(key);
                    if (this.getAttribute(key) == null) {
                        this.doPutOrRemove(key, freshvalue);
                        this.bindValue(key, freshvalue);
                        continue;
                    }
                    this.doPutOrRemove(key, freshvalue);
                }
                for (String key : this.getNames()) {
                    if (fresh.getAttribute(key) != null) continue;
                    Object oldvalue = this.getAttribute(key);
                    this.doPutOrRemove(key, null);
                    this.unbindValue(key, oldvalue);
                }
            }
            this.didActivate();
        }

        public void setExpiry(long expiry) {
            this._expiryTime = expiry;
        }

        public long getExpiry() {
            return this._expiryTime;
        }

        public void swapId(String newId, String newNodeId) {
            this._lock.lock();
            this.setClusterId(newId);
            this.setNodeId(newNodeId);
            this._lock.unlock();
        }

        public void setAttribute(String name, Object value) {
            Object old = this.changeAttribute(name, value);
            if (value == null && old == null) {
                return;
            }
            this._dirty = true;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public void setContextPath(String contextPath) {
            this._contextPath = contextPath;
        }

        public String getVHost() {
            return this._vhost;
        }

        public void setVHost(String vhost) {
            this._vhost = vhost;
        }

        public String getLastNode() {
            return this._lastNode;
        }

        public void setLastNode(String lastNode) {
            this._lastNode = lastNode;
        }

        public long getLastSyncTime() {
            return this._lastSyncTime;
        }

        public void setLastSyncTime(long lastSyncTime) {
            this._lastSyncTime = lastSyncTime;
        }
    }

    public class SerializableSessionData
    implements Serializable {
        private static final long serialVersionUID = -7779120106058533486L;
        String clusterId;
        String contextPath;
        String vhost;
        long accessed;
        long lastAccessed;
        long createTime;
        long cookieSetTime;
        String lastNode;
        long expiry;
        long maxInactive;
        Map<String, Object> attributes;

        public SerializableSessionData() {
        }

        public SerializableSessionData(Session s) {
            this.clusterId = s.getClusterId();
            this.contextPath = s.getContextPath();
            this.vhost = s.getVHost();
            this.accessed = s.getAccessed();
            this.lastAccessed = s.getLastAccessedTime();
            this.createTime = s.getCreationTime();
            this.cookieSetTime = s.getCookieSetTime();
            this.lastNode = s.getLastNode();
            this.expiry = s.getExpiry();
            this.maxInactive = s.getMaxInactiveInterval();
            this.attributes = s.getAttributeMap();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.clusterId);
            out.writeUTF(this.contextPath);
            out.writeUTF(this.vhost);
            out.writeLong(this.accessed);
            out.writeLong(this.lastAccessed);
            out.writeLong(this.createTime);
            out.writeLong(this.cookieSetTime);
            out.writeUTF(this.lastNode);
            out.writeLong(this.expiry);
            out.writeLong(this.maxInactive);
            out.writeObject(this.attributes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.clusterId = in.readUTF();
            this.contextPath = in.readUTF();
            this.vhost = in.readUTF();
            this.accessed = in.readLong();
            this.lastAccessed = in.readLong();
            this.createTime = in.readLong();
            this.cookieSetTime = in.readLong();
            this.lastNode = in.readUTF();
            this.expiry = in.readLong();
            this.maxInactive = in.readLong();
            this.attributes = (HashMap)in.readObject();
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        @Override
        public void run() {
            try {
                InfinispanSessionManager.this.scavenge();
            }
            finally {
                if (InfinispanSessionManager.this._scheduler != null && InfinispanSessionManager.this._scheduler.isRunning()) {
                    InfinispanSessionManager.this._task = InfinispanSessionManager.this._scheduler.schedule((Runnable)this, InfinispanSessionManager.this._scavengeIntervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

