/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.jmx;

import java.security.InvalidParameterException;
import java.util.UUID;
import org.eclipse.jetty.monitor.jmx.EventNotifier;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;
import org.eclipse.jetty.monitor.jmx.NotifierGroup;

public abstract class MonitorAction
extends NotifierGroup {
    public static final int DEFAULT_POLL_INTERVAL = 5000;
    private final String _id;
    private final EventTrigger _trigger;
    private final EventNotifier _notifier;
    private final long _pollInterval;
    private final long _pollDelay;

    public MonitorAction(EventTrigger trigger) throws InvalidParameterException {
        this(trigger, null, 0L, 0L);
    }

    public MonitorAction(EventTrigger trigger, EventNotifier notifier) throws InvalidParameterException {
        this(trigger, notifier, 0L);
    }

    public MonitorAction(EventTrigger trigger, EventNotifier notifier, long pollInterval) throws InvalidParameterException {
        this(trigger, notifier, pollInterval, 0L);
    }

    public MonitorAction(EventTrigger trigger, EventNotifier notifier, long pollInterval, long pollDelay) throws InvalidParameterException {
        if (trigger == null) {
            throw new InvalidParameterException("Trigger cannot be null");
        }
        this._id = UUID.randomUUID().toString();
        this._trigger = trigger;
        this._notifier = notifier;
        this._pollInterval = pollInterval > 0L ? pollInterval : 5000L;
        this._pollDelay = pollDelay > 0L ? pollDelay : this._pollInterval;
    }

    public final String getID() {
        return this._id;
    }

    public EventTrigger getTrigger() {
        return this._trigger;
    }

    public long getPollInterval() {
        return this._pollInterval;
    }

    public long getPollDelay() {
        return this._pollDelay;
    }

    public final void doExecute(long timestamp) {
        EventState<?> state = this._trigger.getState(timestamp);
        if (this._notifier != null) {
            this._notifier.notify(this._trigger, state, timestamp);
        }
        this.execute(this._trigger, state, timestamp);
    }

    public abstract void execute(EventTrigger var1, EventState<?> var2, long var3);
}

