/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.session.infinispan.InfinispanSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.infinispan.commons.api.BasicCache;

public class InfinispanSessionIdManager
extends AbstractSessionIdManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String ID_KEY = "__o.e.j.s.infinispanIdMgr__";
    public static final int DEFAULT_IDLE_EXPIRY_MULTIPLE = 2;
    protected BasicCache<String, Object> _cache;
    private Server _server;
    private int _idleExpiryMultiple = 2;

    public InfinispanSessionIdManager(Server server) {
        this._server = server;
    }

    public InfinispanSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String clusterId = this.getClusterId(id);
        try {
            return this.exists(clusterId);
        }
        catch (Exception e) {
            LOG.warn("Problem checking inUse for id=" + clusterId, (Throwable)e);
            return false;
        }
    }

    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        if (session.getMaxInactiveInterval() == 0) {
            this.insert(((AbstractSession)session).getClusterId());
        } else {
            this.insert(((AbstractSession)session).getClusterId(), session.getMaxInactiveInterval() * this.getIdleExpiryMultiple());
        }
    }

    public void setIdleExpiryMultiple(int multiplier) {
        if (multiplier <= 1) {
            LOG.warn("Idle expiry multiple of {} for session ids set to less than minimum. Using value of {} instead.", new Object[]{multiplier, 2});
        }
        this._idleExpiryMultiple = multiplier;
    }

    public int getIdleExpiryMultiple() {
        return this._idleExpiryMultiple;
    }

    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.delete(((AbstractSession)session).getClusterId());
    }

    public void invalidateAll(String id) {
        this.delete(id);
        Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof InfinispanSessionManager)) continue;
            ((InfinispanSessionManager)manager).invalidateSession(id);
        }
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        this.delete(oldClusterId);
        this.insert(newClusterId);
        Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof InfinispanSessionManager)) continue;
            ((InfinispanSessionManager)manager).renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
        }
    }

    public BasicCache<String, Object> getCache() {
        return this._cache;
    }

    public void setCache(BasicCache<String, Object> cache) {
        this._cache = cache;
    }

    public void touch(String id) {
        this.exists(id);
    }

    protected boolean exists(String id) {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        return this._cache.containsKey((Object)this.makeKey(id));
    }

    protected void insert(String id) {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        this._cache.putIfAbsent((Object)this.makeKey(id), (Object)id);
    }

    protected void insert(String id, long idleTimeOutSec) {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        this._cache.putIfAbsent((Object)this.makeKey(id), (Object)id, -1L, TimeUnit.SECONDS, idleTimeOutSec, TimeUnit.SECONDS);
    }

    protected void delete(String id) {
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        this._cache.remove((Object)this.makeKey(id));
    }

    protected String makeKey(String id) {
        return ID_KEY + id;
    }
}

