/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private volatile transient Constructor<T> cachedConstructor;
    private volatile transient Class<?> newInstanceCallerCache;
    private transient String name;
    private final ClassLoader classLoader;
    private static ProtectionDomain allPermDomain;
    private static boolean useCaches;
    private volatile transient SoftReference<ReflectionData<T>> reflectionData;
    private volatile transient int classRedefinedCount = 0;
    private volatile transient ClassRepository genericInfo;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static ReflectionFactory reflectionFactory;
    private static boolean initted;
    private volatile transient T[] enumConstants = null;
    private volatile transient Map<String, T> enumConstantDirectory = null;
    private volatile transient AnnotationData annotationData;
    private volatile transient AnnotationType annotationType;
    transient ClassValue.ClassValueMap classValueMap;

    private static native void registerNatives();

    private Class(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public String toGenericString() {
        if (this.isPrimitive()) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getModifiers() & Modifier.classModifiers();
        if (n != 0) {
            stringBuilder.append(Modifier.toString(n));
            stringBuilder.append(' ');
        }
        if (this.isAnnotation()) {
            stringBuilder.append('@');
        }
        if (this.isInterface()) {
            stringBuilder.append("interface");
        } else if (this.isEnum()) {
            stringBuilder.append("enum");
        } else {
            stringBuilder.append("class");
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        TypeVariable<Class<T>>[] typeVariableArray = this.getTypeParameters();
        if (typeVariableArray.length > 0) {
            boolean bl = true;
            stringBuilder.append('<');
            for (TypeVariable<Class<T>> typeVariable : typeVariableArray) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(typeVariable.getTypeName());
                bl = false;
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @CallerSensitive
    public static Class<?> forName(String string) throws ClassNotFoundException {
        Class<?> clazz = Reflection.getCallerClass();
        return Class.forName0(string, true, ClassLoader.getClassLoader(clazz), clazz);
    }

    @CallerSensitive
    public static Class<?> forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader classLoader2;
            clazz = Reflection.getCallerClass();
            if (VM.isSystemDomainLoader(classLoader) && !VM.isSystemDomainLoader(classLoader2 = ClassLoader.getClassLoader(clazz))) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
        }
        return Class.forName0(string, bl, classLoader, clazz);
    }

    private static native Class<?> forName0(String var0, boolean var1, ClassLoader var2, Class<?> var3) throws ClassNotFoundException;

    @CallerSensitive
    public T newInstance() throws InstantiationException, IllegalAccessException {
        Class<?> clazz;
        int n;
        Class[] classArray;
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, Reflection.getCallerClass(), false);
        }
        if (this.cachedConstructor == null) {
            if (this == Class.class) {
                throw new IllegalAccessException("Can not call newInstance() on the Class for java.lang.Class");
            }
            try {
                classArray = new Class[]{};
                final Constructor<T> constructor = this.getConstructor0(classArray, 1);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        constructor.setAccessible(true);
                        return null;
                    }
                });
                this.cachedConstructor = constructor;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw (InstantiationException)new InstantiationException(this.getName()).initCause(noSuchMethodException);
            }
        }
        if (!Reflection.quickCheckMemberAccess(this, n = (classArray = this.cachedConstructor).getModifiers()) && this.newInstanceCallerCache != (clazz = Reflection.getCallerClass())) {
            Reflection.ensureMemberAccess(clazz, this, null, n);
            this.newInstanceCallerCache = clazz;
        }
        try {
            return classArray.newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Unsafe.getUnsafe().throwException(invocationTargetException.getTargetException());
            return null;
        }
    }

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        String string = this.name;
        if (string == null) {
            this.name = string = this.getName0();
        }
        return string;
    }

    private native String getName0();

    @CallerSensitive
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader.checkClassLoaderPermission(classLoader, Reflection.getCallerClass());
        }
        return classLoader;
    }

    ClassLoader getClassLoader0() {
        return this.classLoader;
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        ClassRepository classRepository = this.getGenericInfo();
        if (classRepository != null) {
            return classRepository.getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public native Class<? super T> getSuperclass();

    public Type getGenericSuperclass() {
        ClassRepository classRepository = this.getGenericInfo();
        if (classRepository == null) {
            return this.getSuperclass();
        }
        if (this.isInterface()) {
            return null;
        }
        return classRepository.getSuperclass();
    }

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public Class<?>[] getInterfaces() {
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData == null) {
            return this.getInterfaces0();
        }
        Class<?>[] classArray = reflectionData.interfaces;
        if (classArray == null) {
            reflectionData.interfaces = classArray = this.getInterfaces0();
        }
        return (Class[])classArray.clone();
    }

    private native Class<?>[] getInterfaces0();

    public Type[] getGenericInterfaces() {
        ClassRepository classRepository = this.getGenericInfo();
        return classRepository == null ? this.getInterfaces() : classRepository.getSuperInterfaces();
    }

    public native Class<?> getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    @CallerSensitive
    public Method getEnclosingMethod() throws SecurityException {
        EnclosingMethodInfo enclosingMethodInfo = this.getEnclosingMethodInfo();
        if (enclosingMethodInfo == null) {
            return null;
        }
        if (!enclosingMethodInfo.isMethod()) {
            return null;
        }
        MethodRepository methodRepository = MethodRepository.make(enclosingMethodInfo.getDescriptor(), this.getFactory());
        Class<?> clazz = Class.toClass(methodRepository.getReturnType());
        Type[] typeArray = methodRepository.getParameterTypes();
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = Class.toClass(typeArray[i]);
        }
        Class<?> clazz2 = enclosingMethodInfo.getEnclosingClass();
        super.checkMemberAccess(1, Reflection.getCallerClass(), true);
        for (Method method : clazz2.getDeclaredMethods()) {
            Class<?>[] classArray2;
            if (!method.getName().equals(enclosingMethodInfo.getName()) || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].equals(classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl || !method.getReturnType().equals(clazz)) continue;
            return method;
        }
        throw new InternalError("Enclosing method not found");
    }

    private native Object[] getEnclosingMethod0();

    private EnclosingMethodInfo getEnclosingMethodInfo() {
        Object[] objectArray = this.getEnclosingMethod0();
        if (objectArray == null) {
            return null;
        }
        return new EnclosingMethodInfo(objectArray);
    }

    private static Class<?> toClass(Type type) {
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Class.toClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return (Class)type;
    }

    @CallerSensitive
    public Constructor<?> getEnclosingConstructor() throws SecurityException {
        EnclosingMethodInfo enclosingMethodInfo = this.getEnclosingMethodInfo();
        if (enclosingMethodInfo == null) {
            return null;
        }
        if (!enclosingMethodInfo.isConstructor()) {
            return null;
        }
        ConstructorRepository constructorRepository = ConstructorRepository.make(enclosingMethodInfo.getDescriptor(), this.getFactory());
        Type[] typeArray = constructorRepository.getParameterTypes();
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = Class.toClass(typeArray[i]);
        }
        Class<?> clazz = enclosingMethodInfo.getEnclosingClass();
        super.checkMemberAccess(1, Reflection.getCallerClass(), true);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray2 = constructor.getParameterTypes();
            if (classArray2.length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].equals(classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return constructor;
        }
        throw new InternalError("Enclosing constructor not found");
    }

    @CallerSensitive
    public Class<?> getDeclaringClass() throws SecurityException {
        Class<?> clazz = this.getDeclaringClass0();
        if (clazz != null) {
            super.checkPackageAccess(ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return clazz;
    }

    private native Class<?> getDeclaringClass0();

    @CallerSensitive
    public Class<?> getEnclosingClass() throws SecurityException {
        Class<?> clazz;
        EnclosingMethodInfo enclosingMethodInfo = this.getEnclosingMethodInfo();
        if (enclosingMethodInfo == null) {
            clazz = this.getDeclaringClass();
        } else {
            Class<?> clazz2 = enclosingMethodInfo.getEnclosingClass();
            if (clazz2 == this || clazz2 == null) {
                throw new InternalError("Malformed enclosing method information");
            }
            clazz = clazz2;
        }
        if (clazz != null) {
            super.checkPackageAccess(ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return clazz;
    }

    public String getSimpleName() {
        int n;
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String string = this.getSimpleBinaryName();
        if (string == null) {
            string = this.getName();
            return string.substring(string.lastIndexOf(".") + 1);
        }
        int n2 = string.length();
        if (n2 < 1 || string.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (n = 1; n < n2 && Class.isAsciiDigit(string.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    @Override
    public String getTypeName() {
        if (this.isArray()) {
            try {
                Class<?> clazz = this;
                int n = 0;
                while (clazz.isArray()) {
                    ++n;
                    clazz = clazz.getComponentType();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(clazz.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getName();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String string = this.getComponentType().getCanonicalName();
            if (string != null) {
                return string + "[]";
            }
            return null;
        }
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        Class<?> clazz = this.getEnclosingClass();
        if (clazz == null) {
            return this.getName();
        }
        String string = clazz.getCanonicalName();
        if (string == null) {
            return null;
        }
        return string + "." + this.getSimpleName();
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private String getSimpleBinaryName() {
        Class<?> clazz = this.getEnclosingClass();
        if (clazz == null) {
            return null;
        }
        try {
            return this.getName().substring(clazz.getName().length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InternalError("Malformed class name", indexOutOfBoundsException);
        }
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    @CallerSensitive
    public Class<?>[] getClasses() {
        this.checkMemberAccess(0, Reflection.getCallerClass(), false);
        return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class<?>[] run() {
                ArrayList arrayList = new ArrayList();
                for (Class clazz = Class.this; clazz != null; clazz = clazz.getSuperclass()) {
                    Class<?>[] classArray = clazz.getDeclaredClasses();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!Modifier.isPublic(classArray[i].getModifiers())) continue;
                        arrayList.add(classArray[i]);
                    }
                }
                return arrayList.toArray(new Class[0]);
            }
        });
    }

    @CallerSensitive
    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyFields(this.privateGetPublicFields(null));
    }

    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyMethods(this.privateGetPublicMethods());
    }

    @CallerSensitive
    public Constructor<?>[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    @CallerSensitive
    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        Field field = this.getField0(string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    @CallerSensitive
    public Method getMethod(String string, Class<?> ... classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        Method method = this.getMethod0(string, classArray, true);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + string + Class.argumentTypesToString(classArray));
        }
        return method;
    }

    @CallerSensitive
    public Constructor<T> getConstructor(Class<?> ... classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return this.getConstructor0(classArray, 0);
    }

    @CallerSensitive
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), false);
        return this.getDeclaredClasses0();
    }

    @CallerSensitive
    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyFields(this.privateGetDeclaredFields(false));
    }

    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyMethods(this.privateGetDeclaredMethods(false));
    }

    @CallerSensitive
    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    @CallerSensitive
    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        Field field = Class.searchFields(this.privateGetDeclaredFields(false), string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    @CallerSensitive
    public Method getDeclaredMethod(String string, Class<?> ... classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        Method method = Class.searchMethods(this.privateGetDeclaredMethods(false), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + string + Class.argumentTypesToString(classArray));
        }
        return method;
    }

    @CallerSensitive
    public Constructor<T> getDeclaredConstructor(Class<?> ... classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return this.getConstructor0(classArray, 1);
    }

    public InputStream getResourceAsStream(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions permissions = new Permissions();
                permissions.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, permissions);
            }
            protectionDomain = allPermDomain;
        }
        return protectionDomain;
    }

    private native ProtectionDomain getProtectionDomain0();

    static native Class<?> getPrimitiveClass(String var0);

    private void checkMemberAccess(int n, Class<?> clazz, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ClassLoader classLoader = ClassLoader.getClassLoader(clazz);
            ClassLoader classLoader2 = this.getClassLoader0();
            if (n != 0 && classLoader != classLoader2) {
                securityManager.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            this.checkPackageAccess(classLoader, bl);
        }
    }

    private void checkPackageAccess(ClassLoader classLoader, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string;
            int n;
            ClassLoader classLoader2 = this.getClassLoader0();
            if (ReflectUtil.needsPackageAccessCheck(classLoader, classLoader2) && (n = (string = this.getName()).lastIndexOf(46)) != -1) {
                String string2 = string.substring(0, n);
                if (!Proxy.isProxyClass(this) || ReflectUtil.isNonPublicProxyClass(this)) {
                    securityManager.checkPackageAccess(string2);
                }
            }
            if (bl && Proxy.isProxyClass(this)) {
                ReflectUtil.checkProxyPackageAccess(classLoader, this.getInterfaces());
            }
        }
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class<?> clazz = this;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        } else {
            string = string.substring(1);
        }
        return string;
    }

    private ReflectionData<T> reflectionData() {
        ReflectionData<T> reflectionData;
        SoftReference<ReflectionData<T>> softReference = this.reflectionData;
        int n = this.classRedefinedCount;
        if (useCaches && softReference != null && (reflectionData = softReference.get()) != null && reflectionData.redefinedCount == n) {
            return reflectionData;
        }
        return this.newReflectionData(softReference, n);
    }

    private ReflectionData<T> newReflectionData(SoftReference<ReflectionData<T>> softReference, int n) {
        ReflectionData reflectionData;
        if (!useCaches) {
            return null;
        }
        do {
            if (Atomic.casReflectionData(this, softReference, new SoftReference(reflectionData = new ReflectionData(n)))) {
                return reflectionData;
            }
            softReference = this.reflectionData;
            n = this.classRedefinedCount;
        } while (softReference == null || (reflectionData = softReference.get()) == null || reflectionData.redefinedCount != n);
        return reflectionData;
    }

    private native String getGenericSignature0();

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    private ClassRepository getGenericInfo() {
        ClassRepository classRepository = this.genericInfo;
        if (classRepository == null) {
            String string = this.getGenericSignature0();
            classRepository = string == null ? ClassRepository.NONE : ClassRepository.make(string, this.getFactory());
            this.genericInfo = classRepository;
        }
        return classRepository != ClassRepository.NONE ? classRepository : null;
    }

    native byte[] getRawAnnotations();

    native byte[] getRawTypeAnnotations();

    static byte[] getExecutableTypeAnnotationBytes(Executable executable) {
        return Class.getReflectionFactory().getExecutableTypeAnnotationBytes(executable);
    }

    native ConstantPool getConstantPool();

    private Field[] privateGetDeclaredFields(boolean bl) {
        Field[] fieldArray;
        Class.checkInitted();
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData != null) {
            Field[] fieldArray2 = fieldArray = bl ? reflectionData.declaredPublicFields : reflectionData.declaredFields;
            if (fieldArray != null) {
                return fieldArray;
            }
        }
        fieldArray = Reflection.filterFields(this, this.getDeclaredFields0(bl));
        if (reflectionData != null) {
            if (bl) {
                reflectionData.declaredPublicFields = fieldArray;
            } else {
                reflectionData.declaredFields = fieldArray;
            }
        }
        return fieldArray;
    }

    private Field[] privateGetPublicFields(Set<Class<?>> set) {
        Field[] fieldArray;
        Class.checkInitted();
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData != null && (fieldArray = reflectionData.publicFields) != null) {
            return fieldArray;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        if (set == null) {
            set = new HashSet();
        }
        Field[] fieldArray2 = this.privateGetDeclaredFields(true);
        Class.addAll(arrayList, fieldArray2);
        Object object = this.getInterfaces();
        int n = ((Class<?>[])object).length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = object[i];
            if (set.contains(clazz)) continue;
            set.add(clazz);
            Class.addAll(arrayList, super.privateGetPublicFields(set));
        }
        if (!this.isInterface() && (object = this.getSuperclass()) != null) {
            Class.addAll(arrayList, super.privateGetPublicFields(set));
        }
        fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        if (reflectionData != null) {
            reflectionData.publicFields = fieldArray;
        }
        return fieldArray;
    }

    private static void addAll(Collection<Field> collection, Field[] fieldArray) {
        for (int i = 0; i < fieldArray.length; ++i) {
            collection.add(fieldArray[i]);
        }
    }

    private Constructor<T>[] privateGetDeclaredConstructors(boolean bl) {
        Constructor<T>[] constructorArray;
        Class.checkInitted();
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData != null) {
            Constructor<T>[] constructorArray2 = constructorArray = bl ? reflectionData.publicConstructors : reflectionData.declaredConstructors;
            if (constructorArray != null) {
                return constructorArray;
            }
        }
        if (this.isInterface()) {
            Constructor[] constructorArray3 = new Constructor[]{};
            constructorArray = constructorArray3;
        } else {
            constructorArray = this.getDeclaredConstructors0(bl);
        }
        if (reflectionData != null) {
            if (bl) {
                reflectionData.publicConstructors = constructorArray;
            } else {
                reflectionData.declaredConstructors = constructorArray;
            }
        }
        return constructorArray;
    }

    private Method[] privateGetDeclaredMethods(boolean bl) {
        Method[] methodArray;
        Class.checkInitted();
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData != null) {
            Method[] methodArray2 = methodArray = bl ? reflectionData.declaredPublicMethods : reflectionData.declaredMethods;
            if (methodArray != null) {
                return methodArray;
            }
        }
        methodArray = Reflection.filterMethods(this, this.getDeclaredMethods0(bl));
        if (reflectionData != null) {
            if (bl) {
                reflectionData.declaredPublicMethods = methodArray;
            } else {
                reflectionData.declaredMethods = methodArray;
            }
        }
        return methodArray;
    }

    private Method[] privateGetPublicMethods() {
        GenericDeclaration genericDeclaration;
        int n;
        Method[] methodArray;
        Class.checkInitted();
        ReflectionData<T> reflectionData = this.reflectionData();
        if (reflectionData != null && (methodArray = reflectionData.publicMethods) != null) {
            return methodArray;
        }
        MethodArray methodArray2 = new MethodArray();
        Object object = this.privateGetDeclaredMethods(true);
        methodArray2.addAll((Method[])object);
        object = new MethodArray();
        Object object2 = this.getInterfaces();
        int n2 = ((Class<?>[])object2).length;
        for (n = 0; n < n2; ++n) {
            genericDeclaration = object2[n];
            ((MethodArray)object).addInterfaceMethods(super.privateGetPublicMethods());
        }
        if (!this.isInterface() && (object2 = this.getSuperclass()) != null) {
            MethodArray methodArray3 = new MethodArray();
            methodArray3.addAll(super.privateGetPublicMethods());
            for (n = 0; n < methodArray3.length(); ++n) {
                genericDeclaration = methodArray3.get(n);
                if (genericDeclaration == null || Modifier.isAbstract(((Method)genericDeclaration).getModifiers()) || ((Method)genericDeclaration).isDefault()) continue;
                ((MethodArray)object).removeByNameAndDescriptor((Method)genericDeclaration);
            }
            methodArray3.addAll((MethodArray)object);
            object = methodArray3;
        }
        for (int i = 0; i < methodArray2.length(); ++i) {
            Method method = methodArray2.get(i);
            ((MethodArray)object).removeByNameAndDescriptor(method);
        }
        methodArray2.addAllIfNotPresent((MethodArray)object);
        methodArray2.removeLessSpecifics();
        methodArray2.compactAndTrim();
        methodArray = methodArray2.getArray();
        if (reflectionData != null) {
            reflectionData.publicMethods = methodArray;
        }
        return methodArray;
    }

    private static Field searchFields(Field[] fieldArray, String string) {
        String string2 = string.intern();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].getName() != string2) continue;
            return Class.getReflectionFactory().copyField(fieldArray[i]);
        }
        return null;
    }

    private Field getField0(String string) throws NoSuchFieldException {
        Class<T> clazz;
        Field field = Class.searchFields(this.privateGetDeclaredFields(true), string);
        if (field != null) {
            return field;
        }
        Class<?>[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            field = super.getField0(string);
            if (field == null) continue;
            return field;
        }
        if (!this.isInterface() && (clazz = this.getSuperclass()) != null && (field = super.getField0(string)) != null) {
            return field;
        }
        return null;
    }

    private static Method searchMethods(Method[] methodArray, String string, Class<?>[] classArray) {
        Method method = null;
        String string2 = string.intern();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (method2.getName() != string2 || !Class.arrayContentsEq(classArray, method2.getParameterTypes()) || method != null && !method.getReturnType().isAssignableFrom(method2.getReturnType())) continue;
            method = method2;
        }
        return method == null ? method : Class.getReflectionFactory().copyMethod(method);
    }

    private Method getMethod0(String string, Class<?>[] classArray, boolean bl) {
        MethodArray methodArray = new MethodArray(2);
        Method method = this.privateGetMethodRecursive(string, classArray, bl, methodArray);
        if (method != null) {
            return method;
        }
        methodArray.removeLessSpecifics();
        return methodArray.getFirst();
    }

    private Method privateGetMethodRecursive(String string, Class<?>[] classArray, boolean bl, MethodArray methodArray) {
        Class<?>[] classArray2;
        Method method = Class.searchMethods(this.privateGetDeclaredMethods(true), string, classArray);
        if (method != null && (bl || !Modifier.isStatic(method.getModifiers()))) {
            return method;
        }
        if (!this.isInterface() && (classArray2 = this.getSuperclass()) != null && (method = super.getMethod0(string, classArray, true)) != null) {
            return method;
        }
        for (Class<?> clazz : classArray2 = this.getInterfaces()) {
            method = super.getMethod0(string, classArray, false);
            if (method == null) continue;
            methodArray.add(method);
        }
        return null;
    }

    private Constructor<T> getConstructor0(Class<?>[] classArray, int n) throws NoSuchMethodException {
        Constructor<T>[] constructorArray;
        for (Constructor<T> constructor : constructorArray = this.privateGetDeclaredConstructors(n == 0)) {
            if (!Class.arrayContentsEq(classArray, constructor.getParameterTypes())) continue;
            return Class.getReflectionFactory().copyConstructor(constructor);
        }
        throw new NoSuchMethodException(this.getName() + ".<init>" + Class.argumentTypesToString(classArray));
    }

    private static boolean arrayContentsEq(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null || objectArray2.length == 0;
        }
        if (objectArray2 == null) {
            return objectArray.length == 0;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == objectArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static Field[] copyFields(Field[] fieldArray) {
        Field[] fieldArray2 = new Field[fieldArray.length];
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray2[i] = reflectionFactory.copyField(fieldArray[i]);
        }
        return fieldArray2;
    }

    private static Method[] copyMethods(Method[] methodArray) {
        Method[] methodArray2 = new Method[methodArray.length];
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray2[i] = reflectionFactory.copyMethod(methodArray[i]);
        }
        return methodArray2;
    }

    private static <U> Constructor<U>[] copyConstructors(Constructor<U>[] constructorArray) {
        Constructor[] constructorArray2 = (Constructor[])constructorArray.clone();
        ReflectionFactory reflectionFactory = Class.getReflectionFactory();
        for (int i = 0; i < constructorArray2.length; ++i) {
            constructorArray2[i] = reflectionFactory.copyConstructor(constructorArray2[i]);
        }
        return constructorArray2;
    }

    private native Field[] getDeclaredFields0(boolean var1);

    private native Method[] getDeclaredMethods0(boolean var1);

    private native Constructor<T>[] getDeclaredConstructors0(boolean var1);

    private native Class<?>[] getDeclaredClasses0();

    private static String argumentTypesToString(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((clazz = classArray[i]) == null ? "null" : clazz.getName());
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        Object object = classLoader.assertionLock;
        synchronized (object) {
            if (classLoader.classAssertionStatus != null) {
                return classLoader.desiredAssertionStatus(this.getName());
            }
        }
        return Class.desiredAssertionStatus0(this);
    }

    private static native boolean desiredAssertionStatus0(Class<?> var0);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String string = System.getProperty("sun.reflect.noCaches");
                if (string != null && string.equals("true")) {
                    useCaches = false;
                }
                initted = true;
                return null;
            }
        });
    }

    public T[] getEnumConstants() {
        T[] TArray = this.getEnumConstantsShared();
        return TArray != null ? (Object[])TArray.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                final Method method = this.getMethod("values", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        method.setAccessible(true);
                        return null;
                    }
                });
                Object[] objectArray = (Object[])method.invoke(null, new Object[0]);
                this.enumConstants = objectArray;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }
        return this.enumConstants;
    }

    Map<String, T> enumConstantDirectory() {
        if (this.enumConstantDirectory == null) {
            T[] TArray = this.getEnumConstantsShared();
            if (TArray == null) {
                throw new IllegalArgumentException(this.getName() + " is not an enum type");
            }
            HashMap<String, T> hashMap = new HashMap<String, T>(2 * TArray.length);
            for (T t : TArray) {
                hashMap.put(((Enum)t).name(), t);
            }
            this.enumConstantDirectory = hashMap;
        }
        return this.enumConstantDirectory;
    }

    public T cast(Object object) {
        if (object != null && !this.isInstance(object)) {
            throw new ClassCastException(this.cannotCastMsg(object));
        }
        return (T)object;
    }

    private String cannotCastMsg(Object object) {
        return "Cannot cast " + object.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return (A)this.annotationData().annotations.get(clazz);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return GenericDeclaration.super.isAnnotationPresent(clazz);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        AnnotationData annotationData = this.annotationData();
        return AnnotationSupport.getAssociatedAnnotations(annotationData.declaredAnnotations, (Class)this, clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return AnnotationParser.toArray(this.annotationData().annotations);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return (A)this.annotationData().declaredAnnotations.get(clazz);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotationData().declaredAnnotations, clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.annotationData().declaredAnnotations);
    }

    private AnnotationData annotationData() {
        int n;
        AnnotationData annotationData;
        AnnotationData annotationData2;
        do {
            annotationData2 = this.annotationData;
            n = this.classRedefinedCount;
            if (annotationData2 == null || annotationData2.redefinedCount != n) continue;
            return annotationData2;
        } while (!Atomic.casAnnotationData(this, annotationData2, annotationData = this.createAnnotationData(n)));
        return annotationData;
    }

    private AnnotationData createAnnotationData(int n) {
        Map<Class<? extends Annotation>, Annotation> map = AnnotationParser.parseAnnotations(this.getRawAnnotations(), this.getConstantPool(), this);
        Class<T> clazz = this.getSuperclass();
        Map<Class<? extends Annotation>, Annotation> map2 = null;
        if (clazz != null) {
            Map<Class<? extends Annotation>, Annotation> map3 = super.annotationData().annotations;
            for (Map.Entry<Class<? extends Annotation>, Annotation> entry : map3.entrySet()) {
                Class<? extends Annotation> clazz2 = entry.getKey();
                if (!AnnotationType.getInstance(clazz2).isInherited()) continue;
                if (map2 == null) {
                    map2 = new LinkedHashMap<Class<? extends Annotation>, Annotation>((Math.max(map.size(), Math.min(12, map.size() + map3.size())) * 4 + 2) / 3);
                }
                map2.put(clazz2, entry.getValue());
            }
        }
        if (map2 == null) {
            map2 = map;
        } else {
            map2.putAll(map);
        }
        return new AnnotationData(map2, map, n);
    }

    boolean casAnnotationType(AnnotationType annotationType, AnnotationType annotationType2) {
        return Atomic.casAnnotationType(this, annotationType, annotationType2);
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap() {
        return this.annotationData().declaredAnnotations;
    }

    public AnnotatedType getAnnotatedSuperclass() {
        if (this == Object.class || this.isInterface() || this.isArray() || this.isPrimitive() || this == Void.TYPE) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedSuperclass(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    public AnnotatedType[] getAnnotatedInterfaces() {
        return TypeAnnotationParser.buildAnnotatedInterfaces(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    static {
        Class.registerNatives();
        useCaches = true;
        serialPersistentFields = new ObjectStreamField[0];
        initted = false;
    }

    private static class AnnotationData {
        final Map<Class<? extends Annotation>, Annotation> annotations;
        final Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
        final int redefinedCount;

        AnnotationData(Map<Class<? extends Annotation>, Annotation> map, Map<Class<? extends Annotation>, Annotation> map2, int n) {
            this.annotations = map;
            this.declaredAnnotations = map2;
            this.redefinedCount = n;
        }
    }

    private static class Atomic {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private static final long reflectionDataOffset;
        private static final long annotationTypeOffset;
        private static final long annotationDataOffset;

        private Atomic() {
        }

        private static long objectFieldOffset(Field[] fieldArray, String string) {
            Field field = Class.searchFields(fieldArray, string);
            if (field == null) {
                throw new Error("No " + string + " field found in java.lang.Class");
            }
            return unsafe.objectFieldOffset(field);
        }

        static <T> boolean casReflectionData(Class<?> clazz, SoftReference<ReflectionData<T>> softReference, SoftReference<ReflectionData<T>> softReference2) {
            return unsafe.compareAndSwapObject(clazz, reflectionDataOffset, softReference, softReference2);
        }

        static <T> boolean casAnnotationType(Class<?> clazz, AnnotationType annotationType, AnnotationType annotationType2) {
            return unsafe.compareAndSwapObject(clazz, annotationTypeOffset, annotationType, annotationType2);
        }

        static <T> boolean casAnnotationData(Class<?> clazz, AnnotationData annotationData, AnnotationData annotationData2) {
            return unsafe.compareAndSwapObject(clazz, annotationDataOffset, annotationData, annotationData2);
        }

        static {
            Field[] fieldArray = ((Class)Class.class).getDeclaredFields0(false);
            reflectionDataOffset = Atomic.objectFieldOffset(fieldArray, "reflectionData");
            annotationTypeOffset = Atomic.objectFieldOffset(fieldArray, "annotationType");
            annotationDataOffset = Atomic.objectFieldOffset(fieldArray, "annotationData");
        }
    }

    private static final class EnclosingMethodInfo {
        private Class<?> enclosingClass;
        private String name;
        private String descriptor;

        private EnclosingMethodInfo(Object[] objectArray) {
            if (objectArray.length != 3) {
                throw new InternalError("Malformed enclosing method information");
            }
            try {
                this.enclosingClass = (Class)objectArray[0];
                assert (this.enclosingClass != null);
                this.name = (String)objectArray[1];
                this.descriptor = (String)objectArray[2];
                assert (this.name != null && this.descriptor != null || this.name == this.descriptor);
            }
            catch (ClassCastException classCastException) {
                throw new InternalError("Invalid type in enclosing method information", classCastException);
            }
        }

        boolean isPartial() {
            return this.enclosingClass == null || this.name == null || this.descriptor == null;
        }

        boolean isConstructor() {
            return !this.isPartial() && "<init>".equals(this.name);
        }

        boolean isMethod() {
            return !this.isPartial() && !this.isConstructor() && !"<clinit>".equals(this.name);
        }

        Class<?> getEnclosingClass() {
            return this.enclosingClass;
        }

        String getName() {
            return this.name;
        }

        String getDescriptor() {
            return this.descriptor;
        }
    }

    static class MethodArray {
        private Method[] methods;
        private int length;
        private int defaults;

        MethodArray() {
            this(20);
        }

        MethodArray(int n) {
            if (n < 2) {
                throw new IllegalArgumentException("Size should be 2 or more");
            }
            this.methods = new Method[n];
            this.length = 0;
            this.defaults = 0;
        }

        boolean hasDefaults() {
            return this.defaults != 0;
        }

        void add(Method method) {
            if (this.length == this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, 2 * this.methods.length);
            }
            this.methods[this.length++] = method;
            if (method != null && method.isDefault()) {
                ++this.defaults;
            }
        }

        void addAll(Method[] methodArray) {
            for (int i = 0; i < methodArray.length; ++i) {
                this.add(methodArray[i]);
            }
        }

        void addAll(MethodArray methodArray) {
            for (int i = 0; i < methodArray.length(); ++i) {
                this.add(methodArray.get(i));
            }
        }

        void addIfNotPresent(Method method) {
            for (int i = 0; i < this.length; ++i) {
                Method method2 = this.methods[i];
                if (method2 != method && (method2 == null || !method2.equals(method))) continue;
                return;
            }
            this.add(method);
        }

        void addAllIfNotPresent(MethodArray methodArray) {
            for (int i = 0; i < methodArray.length(); ++i) {
                Method method = methodArray.get(i);
                if (method == null) continue;
                this.addIfNotPresent(method);
            }
        }

        void addInterfaceMethods(Method[] methodArray) {
            for (Method method : methodArray) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                this.add(method);
            }
        }

        int length() {
            return this.length;
        }

        Method get(int n) {
            return this.methods[n];
        }

        Method getFirst() {
            for (Method method : this.methods) {
                if (method == null) continue;
                return method;
            }
            return null;
        }

        void removeByNameAndDescriptor(Method method) {
            for (int i = 0; i < this.length; ++i) {
                Method method2 = this.methods[i];
                if (method2 == null || !this.matchesNameAndDescriptor(method2, method)) continue;
                this.remove(i);
            }
        }

        private void remove(int n) {
            if (this.methods[n] != null && this.methods[n].isDefault()) {
                --this.defaults;
            }
            this.methods[n] = null;
        }

        private boolean matchesNameAndDescriptor(Method method, Method method2) {
            return method.getReturnType() == method2.getReturnType() && method.getName() == method2.getName() && Class.arrayContentsEq(method.getParameterTypes(), method2.getParameterTypes());
        }

        void compactAndTrim() {
            int n = 0;
            for (int i = 0; i < this.length; ++i) {
                Method method = this.methods[i];
                if (method == null) continue;
                if (i != n) {
                    this.methods[n] = method;
                }
                ++n;
            }
            if (n != this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, n);
            }
        }

        void removeLessSpecifics() {
            if (!this.hasDefaults()) {
                return;
            }
            for (int i = 0; i < this.length; ++i) {
                Method method = this.get(i);
                if (method == null || !method.isDefault()) continue;
                for (int j = 0; j < this.length; ++j) {
                    Method method2;
                    if (i == j || (method2 = this.get(j)) == null || !this.matchesNameAndDescriptor(method, method2) || !MethodArray.hasMoreSpecificClass(method, method2)) continue;
                    this.remove(j);
                }
            }
        }

        Method[] getArray() {
            return this.methods;
        }

        static boolean hasMoreSpecificClass(Method method, Method method2) {
            Class<?> clazz;
            Class<?> clazz2 = method.getDeclaringClass();
            return clazz2 != (clazz = method2.getDeclaringClass()) && clazz.isAssignableFrom(clazz2);
        }
    }

    private static class ReflectionData<T> {
        volatile Field[] declaredFields;
        volatile Field[] publicFields;
        volatile Method[] declaredMethods;
        volatile Method[] publicMethods;
        volatile Constructor<T>[] declaredConstructors;
        volatile Constructor<T>[] publicConstructors;
        volatile Field[] declaredPublicFields;
        volatile Method[] declaredPublicMethods;
        volatile Class<?>[] interfaces;
        final int redefinedCount;

        ReflectionData(int n) {
            this.redefinedCount = n;
        }
    }
}

