/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.resources.HttpserverMessages;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.server.PortableConnectionImpl;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.spi.http.HttpExchange;
import javax.xml.ws.spi.http.HttpHandler;

final class PortableHttpHandler
extends HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server.http");
    private final HttpAdapter adapter;
    private final Executor executor;

    public PortableHttpHandler(@NotNull HttpAdapter httpAdapter, @Nullable Executor executor) {
        assert (httpAdapter != null);
        this.adapter = httpAdapter;
        this.executor = executor;
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received HTTP request:{0}", httpExchange.getRequestURI());
            }
            if (this.executor != null) {
                this.executor.execute(new HttpHandlerRunnable(httpExchange));
            } else {
                this.handleExchange(httpExchange);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, null, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExchange(HttpExchange httpExchange) throws IOException {
        PortableConnectionImpl portableConnectionImpl = new PortableConnectionImpl(this.adapter, httpExchange);
        try {
            String string;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received HTTP request:{0}", httpExchange.getRequestURI());
            }
            if ((string = httpExchange.getRequestMethod()).equals(GET_METHOD) || string.equals(POST_METHOD) || string.equals(HEAD_METHOD) || string.equals(PUT_METHOD) || string.equals(DELETE_METHOD)) {
                this.adapter.handle(portableConnectionImpl);
            } else {
                logger.warning(HttpserverMessages.UNEXPECTED_HTTP_METHOD(string));
            }
        }
        finally {
            httpExchange.close();
        }
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange httpExchange) {
            this.msg = httpExchange;
        }

        @Override
        public void run() {
            try {
                PortableHttpHandler.this.handleExchange(this.msg);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

