/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;
import java.util.List;

public class FXLoader {
    private static final String POLICY_URL = "policy.url.";
    private static final String JAVAFX_RUNTIME_PROPERTY = "javafx.runtime.home";

    private static void registerJavaFXPolicy(JfxRuntime jfxRuntime) throws MalformedURLException {
        int n = 1;
        while (Security.getProperty(POLICY_URL + n) != null) {
            ++n;
        }
        Security.setProperty(POLICY_URL + n, jfxRuntime.getSecurityPolicy().toURI().toURL().toString());
        System.setProperty(JAVAFX_RUNTIME_PROPERTY, jfxRuntime.getHome().toString());
        Policy.getPolicy().refresh();
    }

    private static void addURL(URLClassLoader uRLClassLoader, URL uRL) throws Exception {
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    public static void loadFX(JfxRuntime jfxRuntime) throws ClassNotFoundException {
        if (null == jfxRuntime) {
            throw new ClassNotFoundException();
        }
        if (jfxRuntime.isExtensionJfx()) {
            return;
        }
        URLClassLoader uRLClassLoader = null;
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            uRLClassLoader = (URLClassLoader)classLoader;
        }
        URL[] uRLArray = jfxRuntime.getURLs();
        if (null == uRLArray) {
            throw new ClassNotFoundException();
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                FXLoader.addURL(uRLClassLoader, uRLArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Failed to add JavaFX Runtime", exception);
            }
        }
        try {
            FXLoader.registerJavaFXPolicy(jfxRuntime);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            throw new ClassNotFoundException();
        }
    }

    public static void loadFX(String string) throws ClassNotFoundException {
        if (null == string || string.length() == 0) {
            string = "2.0+";
        }
        VersionString versionString = new VersionString(string);
        List list = versionString.getAllVersionIDs();
        for (int i = 0; i < list.size(); ++i) {
            VersionID versionID = (VersionID)list.get(i);
            JfxRuntime jfxRuntime = Platform.get().getBestJfxRuntime(versionID);
            if (jfxRuntime == null) continue;
            FXLoader.loadFX(jfxRuntime);
            return;
        }
        throw new ClassNotFoundException();
    }
}

